% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{readHoodData}
\alias{readHoodData}
\title{Read cellular position and annotation data into a list object.}
\usage{
readHoodData(
  spe = NA,
  anno_col = NA,
  cell_pos_dat = NA,
  cell_anno_dat = NA,
  pos_col = NA
)
}
\arguments{
\item{spe}{SpatialExperiment object.}

\item{anno_col}{Character. The column name of the annotation to be used in
the following neighbourhood analysis.}

\item{cell_pos_dat}{data.frame object contains the cellular positions.}

\item{cell_anno_dat}{data.frame object contains the cell annotations.}

\item{pos_col}{Character. If the x and y are in the colData instead of in the
SpatialCoords of spe, can specify this parameter.}
}
\value{
A SpatialExperiment object.
}
\description{
Read cellular position and annotation data into a list object.
}
\examples{
data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

}
