% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_clust.R
\docType{methods}
\name{clustByHood}
\alias{clustByHood}
\alias{clustByHood,matrix-method}
\alias{clustByHood,SpatialExperiment-method}
\title{Cluster the probability matrix with K-means}
\usage{
clustByHood(object, ...)

\S4method{clustByHood}{matrix}(object, k = 2^ncol(object) - 1, iter_max = 1000, nstart = 5)

\S4method{clustByHood}{SpatialExperiment}(
  object,
  pm_cols,
  k = 0,
  iter_max = 1000,
  nstart = 5,
  algo = "Hartigan-Wong",
  val_name = "clusters"
)
}
\arguments{
\item{object}{A probability matrix or a SpatialExperiment.}

\item{...}{Ignore parameter.}

\item{k}{The number of clusters. By default is 2^ncol(object)-1.}

\item{iter_max}{the maximum number of iterations allowed.}

\item{nstart}{how many random sets should be chosen.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is
stored in the colData.}

\item{algo}{Algorithm to be used. Options include
Hartigan-Wong, Lloyd, and MacQueen.}

\item{val_name}{Character. Column name used to store the clusters.}
}
\value{
A probability matrix or a SpatialExperiment object. For latter,
the clustering results are saved in the colData of
the SpatialExperiment object.
}
\description{
Cluster the probability matrix with K-means
}
\examples{

m <- matrix(abs(rnorm(1000 * 100)), 1000, 100)

clust <- clustByHood(m, k = 3)

}
