% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R, R/dplyr_compatibility.R
\name{rename,SummarizedExperiment-method}
\alias{rename,SummarizedExperiment-method}
\alias{rename}
\alias{rename,data.frame-method}
\title{Renaming Contents of \code{SummarizedExperiment} Objects}
\usage{
\S4method{rename}{SummarizedExperiment}(
  x,
  row_data = character(),
  col_data = character(),
  assays = character(),
  ...
)

\S4method{rename}{data.frame}(x, ...)
}
\arguments{
\item{x}{(\code{SummarizedExperiment})\cr object to rename contents in.}

\item{row_data}{(named \code{character})\cr mapping from existing (right-hand side values)
to new (left-hand side names) column names of \code{rowData}.}

\item{col_data}{(named \code{character})\cr mapping from existing (right-hand side values)
to new (left-hand side names) column names of \code{colData}.}

\item{assays}{(named \code{character})\cr mapping from existing (right-hand side values)
to new (left-hand side names) assay names.}

\item{...}{additional arguments (not used here).}
}
\value{
The \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} object with renamed contents.
}
\description{
This method renames columns of the \code{rowData} and \code{colData}, as well as assays, of
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} objects. This increases the flexibility
since renaming can be done before conversion to a \code{\link{HermesData}} object.
}
\examples{
x <- summarized_experiment
# Use deliberately a non-standard assay name in this example.
assayNames(x) <- "count"

# Rename `HGNC` to `symbol` in the `rowData`.
x <- rename(x, row_data = c(symbol = "HGNC"))
head(names(rowData(x)))

# Rename `LowDepthFlag` to `low_depth_flag` in `colData`.
x <- rename(x, col_data = c(low_depth_flag = "LowDepthFlag"))
tail(names(colData(x)))

# Rename assay `count` to `counts`.
x <- rename(x, assays = c(counts = "count"))
assayNames(x)
}
