# We should add a functionality to subset on the samples to be prepared for really large cohorts, question is how specific to the tally file format this can be
# 'names', 'dims' 'range' need to come after '...' since they can be missing.
h5readBlock <- function(
  filename, group, names = c("Counts", "Coverages", "Deletions", "Reference"),
  dims, range, samples = NULL, sampleDimMap = .sampleDimMap, verbose = FALSE
){
  range = IRanges(start = range[1], end = range[2])
  .h5dapplyIRanges( filename = filename, group = group, blocksize = width(range), FUN = function(x) x,
                    names = names, dims = dims, range = range, samples = samples,
                    sampleDimMap = sampleDimMap, verbose = verbose,
                    BPPARAM = NULL
  )[[1]]
}