% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileEquiv_topDown2.R
\name{equivClust}
\alias{equivClust}
\title{For a given level (2, 3, ...) in a GO ontology (BP, MF or CC), compute the equivalence threshold 
  distance matrix and generate a dendrogram from it.}
\usage{
equivClust(ontoLevel, onto, geneLists, trace = TRUE, onTheFlyDev = NULL,
  method = "complete", jobName = paste("Equivalence cluster", onto,
  ontoLevel, method, sep = "_"), ylab = "Equivalence threshold distance",
  alpha = 0.05, precis = 0.001, ...)
}
\arguments{
\item{ontoLevel}{integer (2, 3, ...) level of a GO ontology where the GO profiles are built}

\item{onto}{character, GO ontology ("BP", "MF" or "CC") under consideration}

\item{geneLists}{list of character vectors, each vector stands for the gene names in a given gene set}

\item{trace}{boolean, the full process must be traced? Defaults to TRUE}

\item{onTheFlyDev}{character, name of the graphical device where to immediately display the resulting
diagram. The appropriate names depend on the operating system. Defaults to \code{NULL} and then
nothing is displayed}

\item{method}{character, one of the admissible methods in function \code{hclust}. Defaults to "complete"}

\item{jobName}{character, main plot name, defaults to 
\code{paste("Equivalence cluster", onto, ontoLevel, method, sep = "_")}}

\item{ylab}{character, label of the vertical axis of the plot, defaults to "Equivalence threshold distance"}

\item{alpha}{simultaneous nominal significance level for the equivalence tests to be repeteadly performed,
defaults to 0.05}

\item{precis}{numerical precission in the iterative search of the equivalence threshold distances,
defaults to 0.001}

\item{...}{additional arguments to \code{hclust}}
}
\value{
An object of class \code{equivClust}, descending from class \code{hclust}
  with some additional attributes:
  \describe{
    \item{jobName}{The main job name}
    \item{sub}{The graphic subtittle}
    \item{ylab}{The vertical axis label}
    \item{distMat}{The equivalence threshold distance matrix}
    \item{allComps}{A list with some information on all the pairwise equivalence tests:
    the Euclidean squared distance, its standard error and the corresponding GO profiles}
  }
}
\description{
For a given level (2, 3, ...) in a GO ontology (BP, MF or CC), compute the equivalence threshold 
  distance matrix and generate a dendrogram from it.
}
\details{
Do not confuse the threshold distance matrix with the squared distances computed
in each equivalence test.
}
\examples{
\dontrun{
data(kidneyGeneLists)
clustMF2 <- equivClust(2, "MF", kidneyGeneLists, orgPackage="org.Hs.eg.db")
plot(clustMF2)
plot(clustMF2, 
     main = "Dendrogram (method = complete)", sub = attr(clustMF2, "sub"),
     ylab = "Equivalence threshold distance")
# With the same data, an UPGMA dendrogram:
equivClust(2, "MF", kidneyGeneLists, method = "average",
orgPackage="org.Hs.eg.db")
}
}
