% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{getFeatures}
\alias{getFeatures}
\title{Generate a GRanges containing 'features' from .gff files}
\usage{
getFeatures(gff_file, colours = nice_colours, colour_by_type = TRUE)
}
\arguments{
\item{gff_file}{Location of the gff file to read in.}

\item{colours}{A character vector of colours to be used to colour code
the features.}

\item{colour_by_type}{If \code{TRUE}, the features will be coloured
according to the 'type' field of the gff file. If \code{FALSE}, colours will
be assigned based on the name of the feature (each uniquely named feature
gets its own colour).}
}
\value{
A \linkS4class{GRanges} containing the 'features'. See
\code{\link{drawFeatureTrack}} for a detailed description of the format.
}
\description{
Uses a .gff file to create a \linkS4class{GRanges} of
'features' (e.g. genes or other regions of interest within the genome)
which can then be plotted with the \code{\link{featureDiagram}} or
\code{\link{drawFeatureTrack}} functions.
}
\examples{
## the example .gff
path <- system.file('extdata', 'example.gff3', package='gmoviz')

## coloured by type
getFeatures(path)

## not coloured by type (each uniquely named feature gets its own colour)
getFeatures(path, colour_by_type=FALSE)
}
\seealso{
\code{\link{getLabels}} for a function which reads the entries
of a .gff file into labels rather than 'features'. Also
\code{\link{featureDiagram}} or \code{\link{drawFeatureTrack}} for
functions which can plot this data.
}
