% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{internal}
\alias{internal}
\title{Internal functions}
\description{
This page lists and describes all internal functions of
the R package \code{\link{globalSeq}}.

\strong{Preparation}
\cr \code{\link{intern.estim}}
estimates the parameters of the negative binomial distribution
by maximum likelihood.
\cr \code{\link{intern.permu}}
permutes values across samples,
either across all samples or across samples within subgroups.
\cr \code{\link{intern.score}}
computes the score test statistic.

\strong{Testing}
\cr \code{\link{intern.crude}}
calculates p-values by permutation.
\cr \code{\link{intern.focus}}
calculates p-values by permutation,
focusing on a region of interest.
\cr \code{\link{intern.conva}}
calculates p-values by permutation,
using the method of control variates.

\strong{Decomposition}
\cr \code{\link{intern.cov}}
decomposes the test statistic to show the influence of covariates.
\cr \code{\link{intern.sam}}
decomposes the test statistic to show the influence of samples.
\cr \code{\link{intern.plot}}
plots the contributions of covariates or samples.

\strong{Communication}
\cr \code{\link{intern.chromo}}
runs through all genes on a chromosome.
\cr \code{\link{intern.select}}
identifies local covariates.
\cr \code{\link{intern.matrix}}
transforms data to a numeric matrix.
}
\seealso{
The user functions of the R package \code{\link{globalSeq}} are
\code{\link{cursus}}, \code{\link{omnibus}} and \code{\link{proprius}}.
}
\keyword{internal}
