% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.score}
\alias{intern.score}
\title{Internal function}
\usage{
intern.score(y, R, mu, phi)
}
\arguments{
\item{y}{response variable: numeric vector of length \code{n}}

\item{R}{numeric matrix of dimensions \code{n*n} (see example)}

\item{mu}{mean parameters\strong{:}
numeric vector of length \code{1} or \code{n}}

\item{phi}{dispersion parameter\strong{:}
non-negative real number}
}
\value{
The function returns a real number.
}
\description{
This function calculates the test statistic.
It is called by the function \code{\link{omnibus}}.
}
\examples{
# simulate high-dimensional data
n <- 30
p <- 100
set.seed(1)
y <- rnbinom(n,mu=10,size=1/0.25)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)

# calculate test statistic
R <- X \%*\% t(X) / ncol(X)
mu <- mean(y)
phi <- (var(y)-mu)/mu^2
intern.score(y,R,mu,phi)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions
are \code{\link{cursus}}, \code{\link{omnibus}},
and \code{\link{proprius}}.
}
\keyword{internal}
