% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_cov_parallel.R
\name{networkCovParallel}
\alias{networkCovParallel}
\title{Calculates the covariance network}
\usage{
networkCovParallel(
  xdata,
  buildOutput = "matrix",
  nCores = 1,
  forceRecalcNetwork = FALSE,
  showMessage = FALSE,
  ...,
  build.output = deprecated(),
  n.cores = deprecated(),
  force.recalc.network = deprecated(),
  show.message = deprecated()
)
}
\arguments{
\item{xdata}{base data to calculate network}

\item{buildOutput}{if output returns a 'matrix', 'vector' of the upper triu
without the diagonal or NULL with any other argument}

\item{nCores}{number of cores to be used}

\item{forceRecalcNetwork}{force recalculation, instead of going to cache}

\item{showMessage}{shows cache operation messages}

\item{...}{extra parameters for fun}

\item{build.output}{lifecycle::badge("deprecated")
without the diagonal or NULL with any other argument}

\item{n.cores}{lifecycle::badge("deprecated")}

\item{force.recalc.network}{lifecycle::badge("deprecated")}

\item{show.message}{lifecycle::badge("deprecated")}
}
\value{
depends on build.output parameter
}
\description{
Calculates the covariance network
}
\examples{
n.col <- 6
xdata <- matrix(rnorm(n.col * 4), ncol = n.col)
networkCovParallel(xdata)
}
