% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_apis.R
\name{geneNames}
\alias{geneNames}
\title{Retrieve gene names from biomaRt}
\usage{
geneNames(
  ensemblGenes,
  useCache = TRUE,
  verbose = FALSE,
  ensembl.genes = deprecated(),
  use.cache = deprecated()
)
}
\arguments{
\item{ensemblGenes}{character vector with gene names in ensembl_id format}

\item{useCache}{Boolean indicating if biomaRt cache should be used}

\item{verbose}{When using biomaRt in webservice mode and setting verbose to
TRUE, the XML query to the webservice will be printed.}

\item{ensembl.genes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{use.cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a dataframe with external gene names, ensembl_id
}
\description{
Retrieve gene names from biomaRt
}
\examples{
geneNames(c("ENSG00000114978", "ENSG00000166211", "ENSG00000183688"))
}
