% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_generic.R
\name{.glmSparseNetPrivate}
\alias{.glmSparseNetPrivate}
\title{Calculate GLM model with network-based regularization}
\usage{
.glmSparseNetPrivate(
  fun,
  xdata,
  ydata,
  network,
  experiment = NULL,
  options = networkOptions(),
  ...
)
}
\arguments{
\item{fun}{function to be called (glmnet or cv.glmnet)}

\item{xdata}{input data, can be a matrix or MultiAssayExperiment}

\item{ydata}{response data compatible with glmnet}

\item{network}{type of network, see below}

\item{experiment}{when xdata is a MultiAssayExperiment object this
parameter is required}

\item{options}{options to calculate network}

\item{...}{parameters that glmnet accepts}
}
\value{
an object just as glmnet
network parameter accepts:
\itemize{
\item string to calculate network based on data (correlation, covariance)
\item matrix representing the network
\item vector with already calculated penalty weights (can also be used directly
with glmnet)
}
}
\description{
Calculate GLM model with network-based regularization
}
\keyword{internal}
