% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_label.R
\name{geom_label2}
\alias{geom_label2}
\title{geom_label2}
\usage{
geom_label2(
  mapping = NULL,
  data = NULL,
  ...,
  stat = "identity",
  position = "identity",
  family = "sans",
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings, defaults to NULL.}

\item{data}{A layer specific dataset -
only needed if you want to override the plot defaults.}

\item{...}{other arguments passed on to 'layer'.}

\item{stat}{Name of the stat to modify data.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{family}{"sans" by default, can be any supported font.}

\item{parse}{if 'TRUE', the labels will be parsed as expressions, defaults to 'FALSE'.}

\item{nudge_x}{adjust the horizontal position of the labels.}

\item{nudge_y}{adjust the vertical position of the labels.}

\item{label.padding}{Amount of padding around label, defaults to 'unit(0.25, "lines")'.}

\item{label.r}{Use to set the radius of rounded corners of the label, defaults to 'unit(0.15, "lines")'.}

\item{label.size}{Size of label border, in mm, defaults to 0.25.}

\item{na.rm}{If "FALSE" (default), missing values are removed with a warning. If "TRUE", missing values are silently removed, logical.}

\item{show.legend}{Whether to show legend, logical, defaults to "NA".}

\item{inherit.aes}{Whether to inherit aesthetic mappings, logical, defaults to "TRUE".}
}
\value{
label layer
}
\description{
geom_label2 support aes(subset) via setup_data
}
\details{
'geom_label2' is a modified version of geom_label, with subset aesthetic supported
}
\examples{
library(ggtree)
set.seed(123)
tr<- rtree(15)
x <- ggtree(tr)
x + geom_label2(aes(label = node, subset = isTip == FALSE))
}
\references{
For more detailed demonstration of this function, please refer to chapter A.4.5 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\seealso{
\link[ggplot2:geom_text]{geom_label}
}
\author{
Guangchuang Yu
}
