% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.polygonGate}
\alias{fortify.polygonGate}
\title{Convert a polygonGate to a data.table useful for ggplot}
\usage{
\method{fortify}{polygonGate}(model, data = NULL, nPoints = NULL, ...)
}
\arguments{
\item{model}{polygonGate}

\item{data}{data range used to reset off-bound gate coordinates to prevent interpolating on the extremely large space unnecessarily.}

\item{nPoints}{not used}

\item{...}{not used.}
}
\value{
data.table
}
\description{
It converts the boundaries slot into a data.table
}
\examples{
sqrcut <- matrix(c(300,300,600,600,50,300,300,50),ncol=2,nrow=4)
colnames(sqrcut) <- c("FSC-H","SSC-H")
pg <- polygonGate(filterId="nonDebris", .gate= sqrcut)
fortify(pg) 
}
