% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{createRepository}
\alias{createRepository}
\title{Creates a repository of pathway collections.}
\usage{
createRepository(path, sets, name = NULL, description = NULL)
}
\arguments{
\item{path}{Path to a non-existing directory where the repository
will be created.}

\item{sets}{An object of class \code{CategorizedCollection}.}

\item{name}{Name of the repository. Defaults to \code{NULL} (a
generic name will be given).}

\item{description}{Description of the repository. If NULL
(default), a generic description will be given.}
}
\value{
An object of class \code{repo} that can be passed to
    \code{gep2pep} functions.
}
\description{
Given a database of collections, stores them in a local repository
to be used by \code{gep2pep} functions.
}
\details{
\code{sets} can be created by
    \code{\link{importMSigDB.xml}} or using \code{GSEABase}
    \code{GeneSetCollection} class and then converting it to
    CategorizedCollection. See examples.
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
## Repo root created.
## Repo created.
## [15:45:06] Storing pathway data for collection: c3_TFT
## [15:45:06] Storing pathway data for collection: c3_MIR
## [15:45:06] Storing pathway data for collection: c4_CGN

rp
##         ID    Dims     Size
## c3_TFT_sets   10 18.16 kB
## c3_MIR_sets   10 17.25 kB
## c4_CGN_sets   10   6.9 kB

unlink(repo_path, TRUE)
}
\seealso{
buildPEPs
}
