% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{as.CategorizedCollection}
\alias{as.CategorizedCollection}
\title{Converts GeneSetCollection objects to CategorizedCollection objects.}
\usage{
as.CategorizedCollection(GScollection, category = "uncategorized",
  subCategory = "uncategorized")
}
\arguments{
\item{GScollection}{An object of class \code{GeneSetCollection}.}

\item{category}{The name of the category that all the gene sets
will be assigned to (see details).}

\item{subCategory}{The name of the subcategory that all the gene
sets will be assigned to (see details).}
}
\value{
A CategorizedCollection object
}
\description{
Converts GeneSetCollection objects to CategorizedCollection objects.
}
\details{
This function sets the \code{CollectionType} for each set
    in the collection to {CategorizedCollection}. If
    \code{GScollection} contains \code{BroadCollection} gene sets,
    their fields \code{category} and \code{subcategory} will be
    used. Otherwise the \code{category} and \code{subcategory}
    fields will be used.
}
\examples{
\dontrun{

## To run this example, first obtain the MSigDB database in XML
## format (see
## http://software.broadinstitute.org/gsea/downloads.jsp). It is
## assumed that the database is locally available as the file
## "msigdb_v6.0.xml".

The \\code{importMSigDB.xml} function is just a shortcut to the
following:

db <- getBroadSets("msigdb_v6.1.xml")
db <- as.CategorizedCollection(db)

## The database is now in an acceptable format to create a local
## repository using createRepository
}

## A small sample of the MSigDB as imported by importMSigDB.xml is
## included in gep2pep. The following creates (and deletes) a
## gep2pep repository.

db_sample <- loadSamplePWS()

## The function \\code{as.CategorizedCollection} can also be used to
## create arbitrary gene set collections specifying the categories
## and subcategories once for all the sets:

library(GSEABase)
mysets <- as.CategorizedCollection(
              GeneSetCollection(
                  list(GeneSet(c("g1", "g2"), setName="set1"),
                       GeneSet(c("g3", "g4"), setName="set2"))
                  ),
              category="mycategory",
              subCategory="mysubcategory"
              )
newCollection <- GeneSetCollection(c(db_sample, mysets))

## The created repository will include both the sample gene sets
## and the two sets just created:

repo_path <- file.path(tempdir(), "gep2pepTemp")
rp <- createRepository(repo_path, newCollection)

## removing temporary repository
unlink(repo_path, TRUE)
}
