% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view3dCells.R
\name{view3dCells}
\alias{view3dCells}
\title{Plot cell xyz data in 2d or 3d}
\usage{
view3dCells(
  cells,
  x,
  y,
  z,
  color = "blue",
  colorFun = function(x, pal = seq.int(8)) {
     if (is.character(x)) 
         x <-
    as.numeric(factor(x))
     limits <- range(x)
     pal[findInterval(x, seq(limits[1],
    limits[2], length.out = length(pal) + 1), all.inside = TRUE)]
 },
  shape = "sphere",
  radius = 0.1,
  tag = "cell",
  renderer = c("rgl", "threejs", "none"),
  ...
)
}
\arguments{
\item{cells}{A data.frame.}

\item{x, y, z}{Column names of x, y, z.}

\item{color, shape, radius}{The column names for color, shape, radius or the
value(length=1) of them.}

\item{colorFun}{The function to map values into colors.}

\item{tag}{The tag for controller.}

\item{renderer}{The renderer of the 3D plots. Could be rgl or threejs.
The threejs will create a htmlwidgets. If 'none' is set, a list of object
will be returned.}

\item{...}{Not used.}
}
\value{
A list of threeJsGeometry objects or a
htmlwidget.
}
\description{
Plot cell xyz data with grid or rgl package.
}
\examples{
cells <- readRDS(system.file("extdata", "pbmc_small.3d.rds",
  package = "geomeTriD"
))
view3dCells(cells,
  x = "umap_1", y = "umap_2", z = "umap_3",
  color = "nCount_RNA",
  renderer = "threejs"
)
}
