% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeJsViewer.R
\name{threeJsViewer-shiny}
\alias{threeJsViewer-shiny}
\alias{threejsOutput}
\alias{renderthreeJsViewer}
\title{Shiny bindings for threeJsViewer}
\usage{
threejsOutput(outputId, width = "100\%", height = "600px")

renderthreeJsViewer(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'600px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a threeJsViewer}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the
threeJsViewer widget.
}
\description{
Output and render functions for using threeJsViewer within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
  library(GenomicRanges)
  flamingo <- system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds", package = "geomeTriD")
  x <- readRDS(flamingo[[1]])
  ## resize to bigger value to get better init view
  mcols(x) <- as.data.frame(mcols(x)) * 1e5
  line <- threeJsGeometry(
    x = x$x, y = x$y, z = x$z,
    colors = sample(palette(), length(x), replace = TRUE),
    type = "line",
    properties = list(size = 4)
  )
  library(shiny)
  runApp(list(
    ui = bootstrapPage(
      threejsOutput("plot")
    ),
    server = function(input, output) {
      output$plot <- renderthreeJsViewer({
        threeJsViewer(line)
      })
    }
  ))
}
}
