% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractBAckbonePositions.R
\name{extractBackbonePositions}
\alias{extractBackbonePositions}
\title{Extract the backbone coordinates from output of mdsPlot}
\usage{
extractBackbonePositions(v3d_output, n = "backbone")
}
\arguments{
\item{v3d_output}{The output of \link{mdsPlot} or
\link{view3dStructure} for k=3.}

\item{n}{The backbone name of in the inputs.}
}
\value{
An GRanges object with positions of x0, x1, y0, y1, z0 and z1.
}
\description{
Extract the positions from output of mdsPlot and used as the 'targetObj'
for function create3dGenomicSignals
}
\examples{
library(GenomicRanges)
gi_nij <- readRDS(system.file("extdata", "nij.chr6.51120000.53200000.gi.rds",
                  package = "geomeTriD"))
range_chr6 <- GRanges("chr6", IRanges(51120000, 53200000))
geos <- mdsPlot(gi_nij, range = range_chr6, k = 3, render = "none")
extractBackbonePositions(geos)
}
