% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.m.file.R
\name{write.m.file}
\alias{write.m.file}
\title{Function to write a 'csv' file containing gene lists
(aka gene signatures)}
\usage{
write.m.file(obj, file, ...)
}
\arguments{
\item{obj}{List of gene signatures.}

\item{file}{Filename of the 'csv' file.}

\item{...}{Additional parameters for read.csv function.}
}
\value{
None.
}
\description{
This function allows for writing a 'csv' file containing gene signatures.
Each gene signature is composed of at least four columns: "gene.list" is
the name of the signature on the first line and empty fields below,
"probes" are the probe names, "EntrezGene.ID" are the EntrezGene IDs
and "coefficient" are the coefficients of each probe.
}
\examples{
# load gene modules published by Demsedt et al 2009
data(mod1)
# write these gene modules in a 'csv' file
# Not run: write.m.file(obj=mod1, file="desmedt2009_genemodules.csv")

}
