% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbrm.R
\name{tbrm}
\alias{tbrm}
\title{Function to compute Tukey's Biweight Robust Mean}
\usage{
tbrm(x, C = 9)
}
\arguments{
\item{x}{a numeric vector}

\item{C}{a constant. C is preassigned a value of 9 according to the Cook
reference below but other values are possible.}
}
\value{
A numeric mean.
}
\description{
Computation of Tukey's Biweight Robust Mean, a robust average that is
unaffected by outliers.
}
\details{
This is a one step computation that follows the Affy whitepaper below see
page 22. This function is called by chron to calculate a robust mean. C
determines the point at which outliers are given a weight of 0 and
therefore do not contribute to the calculation of the mean. C=9 sets
values roughly +/-6 standard deviations to 0. C=6 is also used in
tree-ring chronology development. Cook and Kairiukstis (1990) have
further details.
Retrieved from tbrm.
}
\examples{
tbrm(rnorm(100))

}
\references{
Statistical Algorithms Description Document, 2002, Affymetrix. p22.
Cook, E. R. and Kairiukstis, L.A. (1990) Methods of Dendrochronology:
Applications in the Environmental Sciences. ISBN-13: 978-0792305866.
Mosteller, F. and Tukey, J. W. (1977) Data Analysis and Regression:
a second course in statistics. Addison-Wesley. ISBN-13: 978-0201048544.
}
\seealso{
chron
}
