% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncotypedx.R
\name{oncotypedx}
\alias{oncotypedx}
\title{Function to compute the OncotypeDX signature as published by
Paik et al. in 2004.}
\usage{
oncotypedx(data, annot, do.mapping = FALSE, mapping, do.scaling=TRUE,
  verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and
probes in columns, dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named
"EntrezGene.ID", dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must
be performed (in case of ambiguities, the most variant probe is kept
for each gene), FALSE otherwise. Note that for Affymetrix HGU
datasets, the mapping is not necessary.}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe" used
to force the mapping such that the probes are not selected based on
their variance.}

\item{do.scaling}{Should the data be scaled?}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score: Continuous signature scores
\item risk: Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping: Mapping used if necessary.
\item probe: If mapping is performed, this matrix contains the correspondence
between the gene list (aka signature) and gene expression data.
}
}
\description{
This function computes signature scores and risk classifications from
gene expression values following the algorithm used for the OncotypeDX
signature as published by Paik et al. 2004.
}
\details{
Note that for Affymetrix HGU datasets, the mapping is not necessary.
}
\examples{
# load GENE70 signature
data(sig.oncotypedx)
# load NKI dataset
data(nkis)
# compute relapse score
rs.nkis <- oncotypedx(data=data.nkis, annot=annot.nkis, do.mapping=TRUE)
table(rs.nkis$risk)

}
\references{
S. Paik, S. Shak, G. Tang, C. Kim, J. Bakker, M. Cronin, F. L. Baehner,
M. G. Walker, D. Watson, T. Park, W. Hiller, E. R. Fisher, D. L. Wickerham,
J. Bryant, and N. Wolmark (2004) "A Multigene Assay to Predict Recurrence
of Tamoxifen-Treated, Node-Negative Breast Cancer", New England Journal
of Medicine, 351(27):2817-2826.
}
