% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggi.R
\name{ggi}
\alias{ggi}
\title{Function to compute the raw and scaled Gene expression Grade Index (GGI)}
\usage{
ggi(data, annot, do.mapping = FALSE, mapping, hg, verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in columns,
dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named "EntrezGene.ID",
dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be performed
(in case of ambiguities, the most variant probe is kept for each gene), FALSE otherwise.}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe" used to force the
mapping such that the probes are not selected based on their variance.}

\item{hg}{Vector containing the histological grade (HG) status of breast cancer
patients in the dataset.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score: Continuous signature scores
\item risk: Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping: Mapping used if necessary.
\item probe: If mapping is performed, this matrix contains the correspondence between
the gene list (aka signature) and gene expression data.
}
}
\description{
This function computes signature scores and risk classifications from gene expression
values following the algorithm used for the Gene expression Grade Index (GGI).
}
\examples{
# load GGI signature
data(sig.ggi)
# load NKI dataset
data(nkis)
# compute relapse score
ggi.nkis <- ggi(data=data.nkis, annot=annot.nkis, do.mapping=TRUE,
  hg=demo.nkis[ ,"grade"])
table(ggi.nkis$risk)

}
\references{
Sotiriou C, Wirapati P, Loi S, Harris A, Bergh J, Smeds J, Farmer P, Praz V,
Haibe-Kains B, Lallemand F, Buyse M, Piccart MJ and Delorenzi M (2006)
"Gene expression profiling in breast cancer: Understanding the molecular basis
of histologic grade to improve prognosis", Journal of National Cancer Institute,
98:262–272
}
\seealso{
\link{gene76}
}
