% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.pairw.cor.meta.R
\name{compute.pairw.cor.meta}
\alias{compute.pairw.cor.meta}
\title{Function to compute pairwise correlations in a meta-analytical framework}
\usage{
compute.pairw.cor.meta(datas, method = c("pearson", "spearman"))
}
\arguments{
\item{datas}{List of datasets. Each dataset is a matrix of gene expressions with
samples in rows and probes in columns, dimnames being properly defined. All the
datasets must have the same probes.}

\item{method}{Estimator for correlation coefficient, can be either pearson or spearman.}
}
\value{
A list with items:
\itemize{
\item cor  Matrix of meta-estimate of correlation coefficients with probes in rows and
prototypes in columns
\item cor.n Number of samples used to compute meta-estimate of correlation coefficients.
}
}
\description{
This function computes meta-estimate of pairwise correlation coefficients for a
set of genes from a list of gene expression datasets.
}
\examples{
# load VDX dataset
data(vdxs)
# load NKI dataset
data(nkis)
# reduce datasets
ginter <- intersect(annot.vdxs[ ,"EntrezGene.ID"], annot.nkis[ ,"EntrezGene.ID"])
ginter <- ginter[!is.na(ginter)][1:30]
myx <- unique(c(match(ginter, annot.vdxs[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.vdxs), size=20)))
data2.vdxs <- data.vdxs[ ,myx]
annot2.vdxs <- annot.vdxs[myx, ]
myx <- unique(c(match(ginter, annot.nkis[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.nkis), size=20)))
data2.nkis <- data.nkis[ ,myx]
annot2.nkis <- annot.nkis[myx, ]
# mapping of datasets
datas <- list("VDX"=data2.vdxs,"NKI"=data2.nkis)
annots <- list("VDX"=annot2.vdxs, "NKI"=annot2.nkis)
datas.mapped <- map.datasets(datas=datas, annots=annots, do.mapping=TRUE)
# compute meta-estimate of pairwise correlation coefficients
pairwcor <- compute.pairw.cor.meta(datas=datas.mapped$datas, method="pearson")
str(pairwcor)

}
\seealso{
\link{map.datasets}, \link{compute.proto.cor.meta}
}
