% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanPeakLength.r
\name{meanPeakLength}
\alias{meanPeakLength}
\title{Calculates mean (average) peak length for any genomic region.}
\usage{
meanPeakLength(organism, start, end)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}
}
\value{
A vector composed of a single number representing the average peak length found within a genomic interval.
}
\description{
Determines the average peak length of all peaks found within some genomic interval (e.g., 0-500 bp upstream of nearest gene for all genes throughout the genome).
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
sigpeaks <- system.file("extdata", "significantpeaksfile.txt", package="geneXtendeR")
peaksInput(sigpeaks)
meanPeakLength(rat, 0, 500)

}
