% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspotPlot.r
\name{hotspotPlot}
\alias{hotspotPlot}
\title{Graphs hotspots of statistically significant peak activity.}
\usage{
hotspotPlot(totalpeaksfile, significantpeaksfile, organism, start, end, by)
}
\arguments{
\item{totalpeaksfile}{Filename in user's working directory (or full path to filename) containing all peaks.}

\item{significantpeaksfile}{Filename in user's working directory (or full path to filename) containing only significant peaks.}

\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{by}{Interval between consecutive extensions.}
}
\value{
Line plot showing the ratio of significant to total peaks at each interval across the genome.
}
\description{
Makes line plots showing the ratio of statistically significant peaks to the total number of peaks at each genomic interval (e.g., 0-500 bp upstream of every gene in the genome, 500-1000 bp upstream of every gene in the genome, etc.).
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
sigpeaks <- system.file("extdata", "significantpeaksfile.txt", package="geneXtendeR")
hotspotPlot(allpeaks, sigpeaks, rat, 0, 10000, 500)


}
