#' Gene transfer format (GTF) file for rat (Rattus_norvegicus.Rnor_6.0.84)
#'
#' A dataset downloaded from Ensembl that contains the entries of a GTF file for Rattus norvegicus.
#'
#' @docType data
#'
#' @usage data(rat)
#' 
#' @return Demonstrates a rat GTF file downloaded from: ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz.
#'
#' @examples 
#' head(rat)
#' tail(rat)
#'
#' @format A data frame with 748514 rows and 28 variables corresponding to the entries of a GTF file.  Column names are standardized and can be found here: http://www.ensembl.org/info/website/upload/gff.html.
#'
#' @keywords datasets
"rat"
