% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{get_platform_annotations}
\alias{get_platform_annotations}
\title{Retrieve Platform Annotations by Gemma}
\usage{
get_platform_annotations(
  platform,
  annotType = c("noParents", "allParents", "bioProcess"),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE),
  memoised = getOption("gemma.memoise", FALSE),
  unzip = FALSE
)
}
\arguments{
\item{platform}{A platform numerical identifiers or platform short name.}

\item{annotType}{Which GO terms should the output include}

\item{file}{Where to save the annotation file to, or empty to just load into memory}

\item{overwrite}{Whether or not to overwrite an existing file}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{unzip}{Whether or not to unzip the file (if @param file is not empty)}
}
\value{
A table of annotations
\itemize{
\item \code{ElementName}: Probeset names provided by the platform.
Gene symbols for generic annotations typicall used for RNA-seq experiments.
\item \code{GeneSymbols}: Genes that were found to be aligned to
the probe sequence. Note that it is possible for probes to be
non-specific. Alignment to multiple genes are indicated with gene
symbols separated by "|"s
\item \code{GeneNames}: Name of the gene
\item \code{GOTerms}: GO Terms associated with the genes. \code{annotType}
argument can be used to choose which terms should be included.
\item \code{GemmaIDs} and \code{NCBIids}: respective IDs for the genes.
}
}
\description{
Gets Gemma's platform annotations including mappings of microarray probes to genes.
}
\examples{
head(get_platform_annotations("GPL96"))
head(get_platform_annotations('Generic_human_ncbiIds'))
}
\keyword{platform}
