% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveViz.R
\name{saveViz}
\alias{saveViz}
\title{Save a Visualization to File (PDF, PNG, or SVG)}
\usage{
saveViz(
  viz,
  output_dir = ".",
  output_file = "figure_gVenn",
  format = "pdf",
  with_date = TRUE,
  width = 5,
  height = 5,
  resolution = 300,
  verbose = TRUE
)
}
\arguments{
\item{viz}{A visualization object typically created by either
\code{plotVenn()} or \code{plotUpSet()}, but can also be a \code{ggplot2} plot or
any other plot object printable with \code{print()}.}

\item{output_dir}{A string specifying the output directory. Defaults
to \code{"."}.}

\item{output_file}{A string specifying the base filename (without
extension). Defaults to \code{"viz_genomicVenn"}.}

\item{format}{Output format. One of \code{"pdf"}, \code{"png"}, or \code{"svg"}.
Defaults to \code{"pdf"}.}

\item{with_date}{Logical (default \code{TRUE}). Whether to prepend the
current date (from \code{today}) to the filename.}

\item{width}{Width of the output file in inches. Default is 5.}

\item{height}{Height of the output file in inches. Default is 5.}

\item{resolution}{Resolution in DPI (only used for PNG). Default is
300.}

\item{verbose}{Logical. If \code{TRUE}, print a message with the saved
path. Default \code{TRUE}.}
}
\value{
The visualization is saved to a file on disk. Invisibly
returns the full path to the saved file.
}
\description{
This function saves a visualization object to a file in the specified
format and directory. It supports visualizations generated by
\code{plotVenn()}, \code{plotUpSet()}, \code{ggplot2}, or any other plot object that
can be rendered using \code{print()} inside a graphics device. Optionally,
the current date (stored in the \code{today} variable) can be prepended to
the filename.
}
\examples{
# Example with a built-in set dataset
  data(gene_list)
  ov_sets <- computeOverlaps(gene_list)
  venn_plot <- plotVenn(ov_sets)
  saveViz(venn_plot, output_dir = tempdir(), output_file = "venn_sets")

  # Example with a built-in genomic dataset
  data(a549_chipseq_peaks)
  ov_genomic <- computeOverlaps(a549_chipseq_peaks)
  upset_plot <- plotUpSet(ov_genomic)
  saveViz(upset_plot, output_dir = tempdir(), output_file = "upset_genomic")

  # Save as PNG instead of PDF
  saveViz(upset_plot, format = "png", output_dir = tempdir(), output_file = "upset_example")

  # Save as SVG
  saveViz(venn_plot, format = "svg", output_dir = tempdir(), output_file = "venn_example")
}
