% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs_shiny.R
\name{run_shiny}
\alias{run_shiny}
\title{Start a Shiny application for integrated multi-omics data analysis.}
\usage{
run_shiny(multiomics_integration)
}
\arguments{
\item{multiomics_integration}{An object representing the integration of
multi-omics data, compatible with the \code{\link{extract_model_res}}
function.}
}
\value{
No return value. The function starts an interactive Shiny
application.
}
\description{
The \code{run_shiny} function launches an interactive Shiny application that
allows users to explore and analyze integrated multi-omics data through
various visualizations and analyses.
}
\details{
The \code{run_shiny} function extracts model results from
\code{multiomics_integration}, performs preprocessing operations to prepare
the data for the Shiny user interface, creates the user interface and server
for the Shiny application.
}
\examples{
# Example usage:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
# multiomics_integration <- run_multiomics(data = mmultiassay_ov)
# app <- run_shiny(multiomics_integration)

}
\references{
Description of the multi-omics data model and integrated analysis techniques
used.
}
\seealso{
\code{\link{extract_model_res}}
}
\concept{Data analysis}
\concept{Function}
\concept{Integration}
\concept{Interactive}
\concept{Multi-omics}
\concept{Shiny}
\concept{Visualization}
\keyword{analysis}
\keyword{integration}
\keyword{multiomics}
\keyword{shiny}
\keyword{visualization}
