% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_SE.R
\name{merge_SE}
\alias{merge_SE}
\title{Merge multiple Summarized Experiments}
\usage{
merge_SE(
  SElist,
  additional_col_name = "data_source",
  discard_keys = c("normalization_type", "fit_source", "record_id", "isDay0", "swap_sa",
    "control_type", "iso_level", "conc_1", "conc_2")
)
}
\arguments{
\item{SElist}{named list of Summarized Experiments}

\item{additional_col_name}{string with the name of the column that will be
added to assay data for the distinction of possible duplicated metrics
that can arise from multiple projects}

\item{discard_keys}{character vector of string that will be discarded
during creating BumpyMatrix object}
}
\value{
merged SummarizedExperiment object
}
\description{
Merge multiple Summarized Experiments
}
\examples{
se1 <- get_synthetic_data("finalMAE_small")[[1]]
merge_SE(list(se1 = se1, se2 = se1))

}
\keyword{SE_operators}
