% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations-calculate_matrix_metric.R
\name{calculate_matrix_metric}
\alias{calculate_matrix_metric}
\alias{calculate_HSA}
\alias{calculate_Bliss}
\alias{.calculate_matrix_metric}
\title{Calculate a metric for combination data.}
\usage{
calculate_HSA(sa1, series_id1, sa2, series_id2, metric)

calculate_Bliss(
  sa1,
  series_id1,
  sa2,
  series_id2,
  metric,
  measured_col = "smooth"
)

.calculate_matrix_metric(
  sa1,
  series_id1,
  sa2,
  series_id2,
  metric,
  FXN,
  measured_col = "x"
)
}
\arguments{
\item{sa1}{data.table containing single agent data where entries in
\code{series_id2} are all \code{0}. Columns of the data.table include
identifiers and the \code{metric} of interest. Metric is stored in the 'x' column.}

\item{series_id1}{String representing the column within \code{sa1} that
represents id1.}

\item{sa2}{data.table containing single agent data where entries in
\code{series_id1} are all \code{0}. Columns of the data.table include
identifiers and the \code{metric} of interest.n Metric is stored in the 'x' column.}

\item{series_id2}{String representing the column within \code{sa2} that
represents id2.}

\item{metric}{String specifying the metric of interest. Usually either 'GRvalue'
or 'RelativeViability'.}

\item{measured_col}{String specyfying the measured colname.}

\item{FXN}{Function to apply to the single-agent fits to calculate a metric.}
}
\value{
data.table containing a single row for every unique combination of
the two series identifiers and the corresponding calculated metric for
each row.
}
\description{
Calculate a metric based off of single-agent values in combination screens.
}
\details{
\code{calculate_HSA} takes the minimum of the two single agents readouts.
\code{calculate_Bliss} performs Bliss additivity calculation based on the
single agent effects, defined as \code{1-x} for the corresponding
normalization.
See https://www.sciencedirect.com/science/article/pii/S1359644619303460?via\%3Dihub#tb0005
for more details.
}
\examples{
n <- 10
sa1 <- data.table::data.table(conc = seq(n), conc2 = rep(0, n), smooth = seq(n))
sa2 <- data.table::data.table(conc = rep(0, n), conc2 = seq(n), smooth = seq(n))
calculate_HSA(sa1, "conc", sa2, "conc2", "smooth")
n <- 10
sa1 <- data.table::data.table(conc = seq(n), conc2 = rep(0, n), smooth = seq(n))
sa2 <- data.table::data.table(conc = rep(0, n), conc2 = seq(n), smooth = seq(n))
calculate_Bliss(sa1, "conc", sa2, "conc2", "smooth")
}
\keyword{combinations}
