% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSet.R
\docType{methods}
\name{getRawBeta}
\alias{getRawBeta}
\alias{getRawBeta,SampleSet-method}
\title{Computes Beta value from raw signals}
\usage{
getRawBeta(object, offset = 100)

\S4method{getRawBeta}{SampleSet}(object, offset = 100)
}
\arguments{
\item{object}{object of class SampleSet}

\item{offset}{default is 100 as Illumina standard}
}
\value{
a matrix containing the raw beta value for each position and each
samples
}
\description{
Computes Beta value from raw signals
}
\section{Methods (by class)}{
\itemize{
\item \code{SampleSet}: Computes Beta value from raw signals
}}

\examples{
require(minfiData)
pData(RGsetEx)$cell_type <- rep(c("type1","type2"),3)
mySampleSet=fromRGChannelSet(RGsetEx)
r=getRawBeta(mySampleSet)

}
