% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSet.R
\docType{methods}
\name{getNormBeta}
\alias{getNormBeta}
\alias{getNormBeta,SampleSet-method}
\title{Computes Beta values from normalized signals}
\usage{
getNormBeta(object, offset = 100)

\S4method{getNormBeta}{SampleSet}(object, offset = 100)
}
\arguments{
\item{object}{of type SampleSet}

\item{offset}{default is 100 as Illumina standard}
}
\value{
a matrix containing beta after normalization value for each CpG 
position and each samples
}
\description{
Computes Beta values from normalized signals
}
\section{Methods (by class)}{
\itemize{
\item \code{SampleSet}: Computes Beta values from normalized signals
}}

\examples{
require(minfiData)
pData(RGsetEx)$cell_type <- rep(c("type1","type2"),3)
mySampleSet=fromRGChannelSet(RGsetEx)
b=getNormBeta(funtooNorm(mySampleSet))

}
