% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{logLik}
\alias{logLik}
\alias{logLik,fmrsfit-method}
\alias{logLik,logLik-method}
\title{logLik method}
\usage{
logLik(object, ...)

\S4method{logLik}{fmrsfit}(object, ...)
}
\arguments{
\item{object}{An \code{\link{fmrsfit-class}}}

\item{...}{Other possible arguments}
}
\value{
A numeric value
}
\description{
Provides the estimated logLikelihood of an \code{FMRs} model
from an \code{\link{fmrsfit-class}}
}
\examples{
set.seed(1980)
K = 2
D = 10
n = 500
sig = c(1, 1)
piM = c(0.4, 0.6)
r1 = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
Um = 40

dat <- fmrs.gendata(nObs = n, nComp = K, nCov = D, coeff = c(coeff1, coeff2),
dispersion = sig, mixProp = piM, rho = r1, umax = Um, disFamily = 'lnorm')

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta, nComp = K,
disFamily = 'lnorm', initCoeff = rnorm(K*D+K), initDispersion = rep(1, K),
initmixProp = rep(1/K, K))

logLik(res.mle)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
