% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{fmrs.tunsel}
\alias{fmrs.tunsel}
\alias{fmrs.tunsel,ANY-method}
\alias{fmrs.tunsel-method}
\title{fmrs.tunsel method}
\usage{
fmrs.tunsel(y, delta, x, nComp, ...)

\S4method{fmrs.tunsel}{ANY}(
  y,
  delta,
  x,
  nComp,
  disFamily = "lnorm",
  initCoeff,
  initDispersion,
  initmixProp,
  penFamily = "lasso",
  lambRidge = 0,
  nIterEM = 400,
  nIterNR = 2,
  conveps = 1e-08,
  convepsEM = 1e-08,
  convepsNR = 1e-08,
  NRpor = 2,
  gamMixPor = 1,
  activeset,
  lambMCP,
  lambSICA,
  cutpoint = 0.05,
  LambMin = 0.01,
  LambMax = 1,
  nLamb = 100
)
}
\arguments{
\item{y}{Responses (observations)}

\item{delta}{Censoring indicator vector}

\item{x}{Design matrix (covariates)}

\item{nComp}{Order (Number of components) of mixture model}

\item{...}{Other possible options}

\item{disFamily}{A sub-distribution family. The options
are \code{'norm'} for \code{FMR} models,
\code{'lnorm'} for mixture of AFT regression models with Log-Normal
sub-distributions, \code{'weibull'} for mixture of AFT regression
models with Weibull sub-distributions,}

\item{initCoeff}{Vector of initial values for regression coefficients
including intercepts}

\item{initDispersion}{Vector of initial values for standard deviations}

\item{initmixProp}{Vector of initial values for proportion of components}

\item{penFamily}{Penalty name that is used in variable selection method.
The available options are  \code{'lasso'}, \code{'adplasso'},
\code{'mcp'}, \code{'scad'}, \code{'sica'} and \code{'hard'}.}

\item{lambRidge}{A positive value for tuning parameter in Ridge
Regression or Elastic Net}

\item{nIterEM}{Maximum number of iterations for EM algorithm}

\item{nIterNR}{Maximum number of iterations for Newton-Raphson algorithm}

\item{conveps}{A positive value for avoiding NaN in computing divisions}

\item{convepsEM}{A positive value for threshold of convergence in
EM algorithm}

\item{convepsNR}{A positive value for threshold of convergence in
NR algorithm}

\item{NRpor}{A positive interger for maximum number of searches in
NR algorithm}

\item{gamMixPor}{Proportion of mixing parameters in the penalty. The
value must be in the interval [0,1]. If \code{gamMixPor = 0}, the
penalty structure is no longer mixture.}

\item{activeset}{A matrix of zero-one that shows which intercepts and
covariates are active in the fitted fmrs model}

\item{lambMCP}{A positive numbers for \code{mcp}'s extra tuning parameter}

\item{lambSICA}{A positive numbers for \code{sica}'s extra tuning parameter}

\item{cutpoint}{A positive value for shrinking small values of parameter
estimations in the EM algorithm toward zero}

\item{LambMin}{A positive value for minimum value of tuning parameter}

\item{LambMax}{A positive value for maximum value of tuning parameter}

\item{nLamb}{A positive value for number of tuning parameter}
}
\value{
An \code{\link{fmrstunpar-class}} that includes
  component-wise tuning parameter estimates that can be used in
  variable selection procedure.
}
\description{
Provides component-wise tuning parameters using BIC for
  Finite Mixture of Accelerated Failure Time Regression Models
  and Finite Mixture of Regression Models.
}
\details{
The maximizer of penalized Log-Likelihood depends on selecting a
set of good tuning parameters which is a rather thorny issue. We
  choose a value in an equally spaced set of values in
  \eqn{(0, \lambda_{max})} for a pre-specified \eqn{\lambda_{max}}
  that maximize the component-wise
  BIC, \deqn{\hat\lambda_{k} ={argmax}_{\lambda_{k}}BIC_k(\lambda_{k})=
  {argmax}_{\lambda_{k}}\left\{\ell^{c}_{k, n}
  (\hat{\boldsymbol\Psi}_{\lambda_{k}, k}) -
  |d_{\lambda_{k},k}| \log (n)\right\},}
  where \eqn{d_{\lambda_{k},k}=\{j:\hat{\beta}_{\lambda_{k},kj}\neq 0,
  j=1,\ldots,d\}} is the active set  excluding the intercept
  and \eqn{|d_{\lambda_{k},k}|}
  is its size. This approach is much faster than using an \code{nComp}
  by \code{nComp} grid to select the set \eqn{\boldsymbol\lambda} to
  maximize the penallized Log-Likelihood.
}
\examples{
set.seed(1980)
K = 2
D = 10
n = 500
sig = c(1, 1)
piM = c(0.4, 0.6)
r1 = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
Um = 40

dat <- fmrs.gendata(nObs = n, nComp = K, nCov = D, coeff = c(coeff1, coeff2),
dispersion = sig, mixProp = piM, rho = r1, umax = Um, disFamily = 'lnorm')

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta, nComp = K,
disFamily = 'lnorm', initCoeff = rnorm(K*D+K), initDispersion = rep(1, K),
initmixProp = rep(1/K, K))

res.lam <- fmrs.tunsel(y = dat$y, x = dat$x, delta = dat$delta, nComp = K,
disFamily = 'lnorm', initCoeff = c(coefficients(res.mle)),
initDispersion = dispersion(res.mle), initmixProp = mixProp(res.mle),
penFamily = 'adplasso')

show(res.lam)
}
\references{
Shokoohi, F., Khalili, A., Asgharian, M. and Lin, S.
  (2016 submitted) Variable Selection in Mixture of Survival Models for
  Biomedical Genomic Studies
}
\seealso{
Other lnorm, norm, weibull: 
\code{\link{fmrs.gendata}()},
\code{\link{fmrs.mle}()},
\code{\link{fmrs.varsel}()}
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
\concept{fmr, aft, lasso, adplasso, mcp, scad, sica, ridge}
\concept{lnorm, norm, weibull}
\keyword{AFT}
\keyword{Adaptive}
\keyword{Censored}
\keyword{FMRs}
\keyword{LASSO}
\keyword{MCP}
\keyword{Regression}
\keyword{Ridge}
\keyword{SCAD}
\keyword{SICA}
\keyword{Tuning}
