% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{select.particles}
\alias{select.particles}
\title{Performs filtering on a \code{ParticleSet} object}
\usage{
select.particles(particleset, min.area = 1, max.area = 1000)
}
\arguments{
\item{particleset}{A \code{ParticleSet} object. A \code{LinkedParticleSet} object can also be provided as input, yet the returned object will be a \code{ParticleSet} object that needs to be linked again}

\item{min.area}{Size in pixels of the minimum area needed to detect the object as a potential particle of interest}

\item{max.area}{Size in pixels of the maximum area allowed to detect the object as a potential particle of interest}
}
\value{
A \code{ParticleSet} object
}
\description{
According to parameters of interests, such as size, eccentricity/shape, filters out the particles that do not
satisfy the indicated requirements
}
\examples{
data("candidate.platelets")
selected.platelets <- select.particles(candidate.platelets, min.area = 5)
selected.platelets

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
