% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{plot.TrajectorySet}
\alias{plot.TrajectorySet}
\title{3D representation of a \code{TrajectorySet} object}
\usage{
\method{plot}{TrajectorySet}(x, frames, verbose = FALSE, ...)
}
\arguments{
\item{x}{A \code{TrajectorySet} object}

\item{frames}{A \code{Frames} object, used here to identify the limits of the region of interest}

\item{verbose}{Logical, whether to provide additional output on the command line}

\item{...}{Arguments to be passed to methods}
}
\value{
\code{plot.TrajectorySet} returns an invisible \code{NULL}.
}
\description{
Provides a visual representation of a \code{TrajectorySet} object
}
\details{
Based on the \code{plotly} library, the function extracts the region of interests
from the dimensions of an image of the \code{Frames} object,
and afterwards plots the x-y-time representation of the identified trajectories
}
\examples{
data("MesenteriumSubset")
data("candidate.platelets")
platelets.trajectories <- trajectories(candidate.platelets)
\dontrun{
plot(platelets.trajectories,MesenteriumSubset)
}
}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
