% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{normalizeFrames}
\alias{normalizeFrames}
\title{Normalize the values of a \code{Frames} object}
\usage{
normalizeFrames(frames, normFun = "median")
}
\arguments{
\item{frames}{A \code{Frames} object to normalize}

\item{normFun}{The normalization function chosen. Can be one of \code{mean} or \code{median}}
}
\value{
A \code{Frames} object with normalized pixel values.
}
\description{
Applies a transformation to the \code{Frames} object in a way that the intensities
throughout the acquisition are normalized overall in term of pixel values sums.
It can be used to compensate for example a global change in the illumination values,
e.g. due to changed acquisition conditions in experiments that span long timescales.
}
\examples{
data(MesenteriumSubset)
normalizeFrames(MesenteriumSubset,normFun="median") 
}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
