% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinematics.R
\name{extractKinematics.traj}
\alias{extractKinematics.traj}
\title{Calculate a set of kinematics parameters from a single trajectory}
\usage{
extractKinematics.traj(
  trajectoryset,
  trajectoryID,
  acquisitionFrequency = 30,
  scala = 50
)
}
\arguments{
\item{trajectoryset}{A \code{TrajectorySet} object}

\item{trajectoryID}{The ID of a single trajectory}

\item{acquisitionFrequency}{The frame rate of acquisition for the images, in
milliseconds}

\item{scala}{The value of micro(?)meters to which each single pixel
corresponds}
}
\value{
A \code{KinematicsFeatures} object
}
\description{
The computed set of parameters include \code{delta.x}, \code{delta.t} and \code{delta.v}
(displacements and instantaneous velocity), \code{totalTime}, \code{totalDistance},
\code{distStartToEnd}, \code{curvilinearVelocity}, \code{straightLineVelocity} and
\code{linearityForwardProgression}, Mean Squared Displacement, velocity
autocorrelation, and more
}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
