% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet_Methods.R, R/utils.R
\name{gs_pop_get_count_fast}
\alias{gs_pop_get_count_fast}
\alias{getPopStats,GatingSet-method}
\alias{gs_pop_get_count_with_meta}
\title{Return a table of population statistics for all populations in a GatingHierarchy/GatingSet
  or the population proportions or the total number of events of a node (population) in a GatingHierarchy}
\usage{
gs_pop_get_count_fast(
  x,
  statistic = c("count", "freq"),
  xml = FALSE,
  subpopulations = NULL,
  format = c("long", "wide"),
  path = "full",
  ...
)

gs_pop_get_count_with_meta(x, ...)
}
\arguments{
\item{x}{a \code{GatingSet} or \code{GatingSetList}}

\item{statistic}{\code{character} specifies the type of population statistics to extract.(only valid when format is "wide"). Either "freq" or "count" is currently supported.}

\item{xml}{\code{logical} indicating whether the statistics come from xml (if parsed from xml workspace) or from openCyto.}

\item{subpopulations}{\code{character} vector to specify a subset of populations to return. (only valid when format is "long")}

\item{format}{\code{character} value of c("wide", "long") specifing whether to origanize the output in long or wide format}

\item{path}{\code{character} see \link{gs_get_pop_paths}}

\item{...}{additional arguments passed to \code{gs_pop_get_count_fast}}
}
\value{
gs_pop_get_count_fast returns a \code{data.frame} with columns for the population name, xml derived counts, openCyto derived counts, and the population proportions (relative to their parent pouplation).

a \code{data.table} of merged population statistics with sample metadata.
}
\description{
gs_pop_get_count_fast is more useful than getPop. Returns a table of population statistics for all populations in a \code{GatingHierarchy}/\code{GatingSet}. Includes the xml counts, openCyto counts and frequencies.
}
\details{
gs_pop_get_count_fast returns a table population statistics for all populations in the gating hierarchy. The output is useful for verifying that the import was successful, if the xml and openCyto derived counts don't differ much (i.e. if they have a small coefficient of variation.) for a GatingSet, returns a matrix of proportions for all populations and all samples
}
\examples{
        \dontrun{
        #gh is a GatingHierarchy
        gs_pop_get_count_fast(gh);
        gh_pop_get_stats(gh,gs_get_pop_paths(gh,tsort=T)[5])

        #gs is a GatingSet
        gs_pop_get_count_fast(gs)
        #optionally output in long format as a data.table
        gs_pop_get_count_fast(gs, format = "long", path = "auto")
        #only get stats for a subset of populations
        gs_pop_get_count_fast(gs, format = "long", subpopulations = gs_get_pop_paths(gs)[4:6])
        }
 \dontrun{
    #G is a GatingSetList
    stats = gs_pop_get_count_with_meta(G)
  }
}
\seealso{
\code{\link{gs_get_pop_paths}}
}
