% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingHierarchy_Methods.R
\name{gs_get_pop_paths}
\alias{gs_get_pop_paths}
\alias{gh_get_pop_paths}
\alias{getNodes}
\alias{getNodes,GatingSet-method}
\title{Get the names of all nodes from a gating hierarchy.}
\usage{
gs_get_pop_paths(
  x,
  y = NULL,
  order = "regular",
  path = "full",
  showHidden = FALSE,
  ...
)

gh_get_pop_paths(
  x,
  y = NULL,
  order = "regular",
  path = "full",
  showHidden = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{GatingSet} Assuming the gating hierarchy are identical within the \code{GatingSet}, the Gating tree of the first sample is used to query the node information.}

\item{y}{A \code{character} not used.}

\item{order}{\code{order=c("regular","tsort","bfs")} returns the nodes in regular, topological or breadth-first sort order.
"regular" is default.}

\item{path}{A \code{character} or \code{numeric} scalar. when \code{numeric}, it specifies the fixed length of gating path (length 1 displays terminal name).
When \code{character}, it can be either 'full' (full path, which is default) or 'auto' (display the shortest unique gating path from the bottom of gating tree).}

\item{showHidden}{\code{logical} whether to include the hidden nodes}

\item{...}{Additional arguments.}
}
\value{
gs_get_pop_paths returns a \code{character} vector of node/population names, ordered appropriately.
}
\description{
\code{gs_get_pop_paths} returns a character vector of names of the nodes (populations) in the \code{GatingSet}.
}
\details{
integer indices of nodes are based on regular order,so whenver need to map from character node name to integer node ID,make sure
to use default order which is regular.
}
\examples{
  \dontrun{
    # G is a gating hierarchy
    gs_get_pop_paths(G, path = 1)#return node names (without prefix)
    gs_get_pop_paths(G, path = "full")#return the full path
    gs_get_pop_paths(G, path = 2)#return the path as length of two
    gs_get_pop_paths(G, path = "auto")#automatically determine the length of path
    gs_pop_set_name(G, "L", "lymph")
  }
}
