% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GatingSet-class}
\alias{GatingSet-class}
\alias{GatingSet}
\title{Class \code{"GatingSet"}}
\description{
GatingSet holds a set of \code{GatingHierarchy} objects, representing a set of samples and the gating scheme associated with each.
}
\details{
Objects stores a collection of GatingHierarchies and represent a group in a flowJo workspace.
A GatingSet can have two ``states''. After a call to flowjo_to_gatingset(...,execute=FALSE)
, the workspace is imported but the data is not. Setting \code{execute} to \code{TRUE} is needed in order to load, 
transform, compensate, and gate the associated data. Whether or not a GatingHierarchy has been applied to data is encoded in the \code{flag} slot. Some methods will warn the user, or may not function correctly if the GatingHierarchy has not been executed.
This mechanism is in place, largely for the purpose of speed when working with larger workspaces. 
It allows the use to load a workspace and subset desired samples before proceeding to load the data.
}
\section{Slots}{


\describe{
    \item{\code{pointer}:}{Object of class \code{"externalptr"}. points to the gating hierarchy stored in C data structure.}
    \item{\code{transformation}:}{Object of class \code{"list"}. a list of transformation objects used by GatingSet.}
  }
}

\examples{
\dontrun{
 require(flowWorkspaceData)
 d<-system.file("extdata",package="flowWorkspaceData")
 wsfile<-list.files(d,pattern="A2004Analysis.xml",full=TRUE)
 library(CytoML)
 ws <- open_flowjo_xml(wsfile);
 G<-try(flowjo_to_gatingset(ws,execute=TRUE,path=d,name=1));
 gs_plot_pop_count_cv(G);
}
}
\seealso{
\code{\linkS4class{GatingHierarchy}}
}
