% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStats.R
\name{gs_pop_get_stats_tfilter}
\alias{gs_pop_get_stats_tfilter}
\alias{gh_pop_get_stats_tfilter}
\title{Extract stats from populations(or nodes) within a restricted time window}
\usage{
gs_pop_get_stats_tfilter(x, ...)

gh_pop_get_stats_tfilter(
  x,
  nodes = NULL,
  type = c("Count", "Frequency"),
  inverse.transform = FALSE,
  stats.fun.arg = list(),
  tfilter = NULL,
  path = c("full", "auto"),
  ...
)
}
\arguments{
\item{x}{GatingSet or GatingHierarchy}

\item{nodes}{the character vector specifies the populations of interest. default is all available nodes}

\item{type}{the character vector specifies the type of pop stats or
a function used to compute population stats.
When it is a character, it is expected to be either "Count" or "Frequency". Default is "Count" (total number of events in the populations).
When it is a function,  it takes a flowFrame object through the 'fr' argument and returns the stats as a named vector.}

\item{inverse.transform}{logical flag . Whether to inverse transform the data before computing the stats.}

\item{stats.fun.arg}{a list of arguments passed to `type` when 'type' is a function.}

\item{tfilter}{Either a list (tmin, tmax) specifying the minimum and maximum of a the time window filter 
or a GatingHierarchy, whose minimum and maximum time will be used to determine the window.
For both x and the reference GatingHierarchy in tfilter, the only channels
that will match this filter are "Time" or "time" and the filter will be applied to each event
such that only events with time value t where tmin <= t <= tmax will be evaluated.}

\item{path, ...}{arguments passed to 'gh_get_pop_paths()'}
}
\description{
Extract stats from populations(or nodes) within a restricted time window
}
