% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{booleanFilter-class}
\alias{booleanFilter-class}
\alias{show,booleanFilter-method}
\alias{booleanFilter}
\alias{char2booleanFilter}
\title{A class describing logical operation (& or |) of the reference populations}
\usage{
booleanFilter(expr, ..., filterId = "defaultBooleanFilter")

char2booleanFilter(expr, ..., filterId = "defaultBooleanFilter")
}
\arguments{
\item{expr}{\code{expression}}

\item{...}{further arguments to the expression}

\item{filterId}{\code{character} identifier}
}
\description{
\code{booleanFilter} class inherits class \code{\link{expressionFilter}} and exists for the purpose of methods dispatching.
}
\examples{
# "4+/TNFa+" and "4+/IL2+" are two existing gates
#note: no spaces between node names and & , ! operators
booleanFilter(`4+/TNFa+&!4+/IL2+`)

#programmatically 
n1 <- "4+/TNFa+"
n2 <- "4+/IL2+"
exprs <- paste0(n1, "&!", n2)
call <- substitute(booleanFilter(v), list(v = as.symbol(exprs)))
eval(call)
}
\seealso{
\code{\link{add}} \code{\linkS4class{GatingHierarchy}}
}
