% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryAnalysis.R
\name{summarizeFlow}
\alias{summarizeFlow}
\title{Generate summary statistics for a flowSet}
\usage{
summarizeFlow(
  flowset,
  channel = NA,
  gated = FALSE,
  ploidy = FALSE,
  only = FALSE
)
}
\arguments{
\item{flowset}{the \code{flowSet} to be summarized}

\item{channel}{\code{character vector} which data channel(s) should be
summarized? If excluded (or \code{NA}) all channels will be summarized
(default)}

\item{gated}{\code{boolean} is the data already appropriately gated?}

\item{ploidy}{\code{character} does the flowSet contain haploid or diploid
cells?}

\item{only}{\code{character} summarize only "singlet", "doublet", or all
"yeast" cells, FALSE will return all}
}
\value{
\code{data frame} containing the specified summary statistics of
the specified cell populations for each frame
}
\description{
Gates a sample to all yeast, then singlet, then doublets.
Also calculates singlet to doublet ratio.
Returns a list of data frames, e.g. output$singlets, output$doublets, etc.
}
\examples{
plate1 <- read.flowSet(path = system.file("extdata", "ss_example",
package = "flowTime"), alter.names = TRUE)
summarizeFlow(plate1, channel = "FL1.A", gated = TRUE,
ploidy = "diploid", only = "yeast")

}
