% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{read.plateSet}
\alias{read.plateSet}
\title{Read FCS files from set of plates}
\usage{
read.plateSet(path = getwd(), pattern = "", ...)
}
\arguments{
\item{path}{The path to search for folders containing FCS files}

\item{pattern}{The \link[base]{regex} pattern used to identify
the folders of FCS files to be read}

\item{...}{Additional arguments passed to read.flowSet.
Note that `alter.names` is forced to be TRUE in this implementation.}
}
\value{
A single flowSet containing all FCS files within the
identified folders. The index of each folder in the list according
to lexicographical ordering (1,2,...) is prepended to the sampleNames.
}
\description{
Reads all folders within the specified path containing the
specified pattern in the folder names. Each folder contains a set a plate
of FCS files. These folders typically make up a whole experiment. Plates
are numbered according to the standard lexicographical ordering of your
operating system.
}
\examples{
# Read in both of the example data sets as a single flowSet
plate1<-read.plateSet(path = system.file("extdata", package = "flowTime"),
pattern = "")

}
