       
\name{plotBins}
\alias{plotBins}

\title{ Plots the probability bins overlaid with flowFrame data}

\description{
This function is useful in visualizing the differences between the binned control
and sample datasets. The bins generated from the control dataset are 
overlaid with the sample dataset. An optional argument residuals can be used to 
shade each bin based on a calculated statistical measure of difference between 
the number of events in each bin.
}

\usage{
plotBins(binRes,data,channels,title,residuals,shadeFactor)
}

\arguments{
  
  \item{binRes}{ The result generated by calling the \code{probBin}
    function on a control dataset.}

  \item{data}{ An object of class
    \code{\link[flowCore:flowFrame-class]{flowFrame}} 
    sample(dataset)}
  
  \item{channels}{ The flow parameters to be plotted.In cases where more
    than two parameters are binned from the control set, the
    \code{plotBins} function plots the projections of the hyperplanes in
    2 dimensions)}
  
  \item{title}{ Optional title for the plot generated}

  \item{residuals}{ A vector of length equal to the number of bins
    generated that can be used to shade each bin. The residuals from the
    \code{calcPearsonChi} function or the \code{calcPBChiSquare}
    function can be used to highlight the bins that are different
    between control and sample datasets}
  
  \item{shadeFactor}{ Optional argument between 0 and 1 that controls
    the intensity of the shading of bins}
  
}

\author{Nishant Gopalakrishnan}

\seealso{ \code{\link{proBin}}, \code{\link{calcPearsonChi}},
 \code{\link{calcPBChiSquare}}}

\examples{
library(flowCore)
data(GvHD)
# flow frame 1 is treated as  control dataset and used to generate bins
resCtrl<-proBin(GvHD[[1]],200,channels=c("FSC-H","SSC-H"))
plotBins(resCtrl,GvHD[[1]],channels=c("FSC-H","SSC-H"),title="Binned control data")
# Same bins are applied to flowFrame 16
resSample<-binByRef(resCtrl,GvHD[[16]])
stat<-calcPearsonChi(resCtrl,resSample)
dev.new()
plotBins(resCtrl,data=GvHD[[16]],channels=c("FSC-H","SSC-H","Time"),title="Comparision 1 & 16",
residuals=stat$residuals[2,],shadeFactor=0.7)

}

\keyword{misc}
