% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{resetFlowHist}
\alias{resetFlowHist}
\title{Reset the values in a \code{\link{FlowHist}} object}
\usage{
resetFlowHist(fh, from = "peaks")
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object.}

\item{from}{character, the point in the \code{\link{FlowHist}} process
to reset from (see details).}
}
\value{
the updated \code{\link{FlowHist}} object.
}
\description{
NB: This function isn't required for normal use, and isn't exported for
general use. It's provided as a convenience for anyone interested in
tweaking model construction and associated parameters. Regular users
don't need to do this!
}
\details{
This function provides a safe way to reset the values in a
\code{\link{FlowHist}} object. This is important because changing
something early in the process will require updating all the dependent
values in the appropriate order.

The dependency relationships are:

\code{gate} <- \code{peaks} <- \code{comps} <- \code{limits}

Consequently, changing the \code{gate} requires updating \code{peaks},
\code{comps} and \code{limits}. Changing \code{components} only requires
updating the \code{limits}. Updating \code{limits} implicitly updates
the model and subsequent analysis (i.e., NLS, CV, counts and RCS).

In practice, this means that if you change the components, you should
call \code{resetFlowHist} to update the dependencies. i.e.,
\code{resetFlowHist(fh, from = "limits")}.
}
\author{
Tyler Smith
}
\keyword{internal}
