% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_rm_feature}
\alias{fg_rm_feature}
\title{Removes a feature.}
\usage{
fg_rm_feature(fg, type = "node", feature = NULL)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string specifying the type of the feature being
removed i.e. 'node' or 'edge'.}

\item{feature}{A string indicating the unique name of the feature removed;
note we cannot remove the 'node' 'count' feature type.}
}
\value{
flowGraph object with specified feature removed.
}
\description{
Removes a feature from a given flowGraph object.
}
\details{
\code{fg_rm_feature} removes a specified feature matrix from the
 given flowGraph object \code{fg} updating slots
 \code{feat} and \code{feat_desc}.
 See \code{\link[flowGraph]{flowGraph-class}}
 slot \code{feat} and \code{feat_desc} for what should be in these slots.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)
 fg_get_feature_desc(fg)

 fg <- fg_rm_feature(fg, type="node", feature="prop")
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_rm_summary}}
}
