% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{scaleTransform}
\alias{scaleTransform}
\title{Create the definition of a scale transformation function to be applied on a
data set}
\usage{
scaleTransform(transformationId="defaultScaleTransform", a, b)
}
\arguments{
\item{transformationId}{character string to identify the transformation}

\item{a}{double that corresponds to the value that will be transformed to 0}

\item{b}{double that corresponds to the value that will be transformed to 1}
}
\value{
Returns an object of class \code{transform}.
}
\description{
Create the definition of the scale Transformation that will be applied on
some parameter via the \code{transform} method.  The definition of this
function is currently x = (x-a)/(b-a).  The transformation would normally be
used to convert to a 0-1 scale. In this case, b would be the maximum
possible value and a would be the minimum possible value.
}
\examples{

samp <- read.FCS(system.file("extdata",
   "0877408774.B08", package="flowCore"))
  scaleTrans <- scaleTransform(transformationId="Truncate-transformation", a=1, b=10^4)
  dataTransform <- transform(samp, transformList('FSC-H', scaleTrans))

}
\seealso{
\code{\link{transform-class}}, \code{\link{transform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{inverseLogicleTransform}()},
\code{\link{linearTransform}()},
\code{\link{lnTransform}()},
\code{\link{logTransform}()},
\code{\link{logicleTransform}()},
\code{\link{quadraticTransform}()},
\code{\link{splitScaleTransform}()},
\code{\link{truncateTransform}()}
}
\author{
P. Haaland
}
\concept{Transform functions}
\keyword{methods}
